/****************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtXmlPatterns module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:COMM$
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** $QT_END_LICENSE$
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
****************************************************************************/

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists purely as an
// implementation detail.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.

#ifndef Patternist_TripleContainer_H
#define Patternist_TripleContainer_H

#include <private/qexpression_p.h>

QT_BEGIN_NAMESPACE

namespace QPatternist
{
    /**
     * @short Base class for expressions that has exactly three operands.
     *
     * @author Frans Englich <frans.englich@nokia.com>
     * @ingroup Patternist_expressions
     */
    class TripleContainer : public Expression
    {
    public:
        virtual Expression::List operands() const;
        virtual void setOperands(const Expression::List &operands);

        virtual bool compressOperands(const StaticContext::Ptr &);

    protected:
        TripleContainer(const Expression::Ptr &operand1,
                        const Expression::Ptr &operand2,
                        const Expression::Ptr &operand3);

        Expression::Ptr m_operand1;
        Expression::Ptr m_operand2;
        Expression::Ptr m_operand3;
    };
}

QT_END_NAMESPACE

#endif
